<%@ Page Title="TBI Instruments - MPAI Instrument Questions / Answers" Language="C#" MasterPageFile="RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentMpaiEntry.aspx.cs" Inherits="TBI_InstrumentMpaiEntry" MaintainScrollPositionOnPostback="true" %>
<%@ Import Namespace="VeteransAffairs.Registries.Business"%>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>


<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">

<link type = "text/css" href ="~/styles/StyleSheet.css" />
    
    <style type="text/css">
            .breadcrumbInstrument {
                background-color:#6B1424;
                border-bottom:1px solid #000;
                color:#FFF;
                font-family:Verdana, Geneva, Arial, Helvetica, sans-serif;
                font-variant:small-caps;
                font-weight:700;
                letter-spacing:1px;
                margin: 2px 0 2px 0;
                padding:8px 25px 5px 10px;
            }
            
    </style>
</asp:Content> 

 <asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeOut="400" runat="server">
    </asp:ScriptManager>
    
    <script type="text/javascript">
        var tmr = null;

        function getTimerReference() {
            if (tmr == null) {
                tmr = $find("<%= InactiveTimer.ClientID %>");
            }

            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable button during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            $('#<%= PanelQuestions.ClientID %>').hide();
        }
        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
        }

    </script>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
<script type = "text/javascript">

    $(document).ready(function () {

        //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
        //also resets inactive timer
        $('input').keydown(function (e) {
            StopTimer();
            StartTimer();
            //if (e.keyCode == 13) { return false; }
        });

        //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
        //also resets inactive timer
        $('div').keydown(function (e) {
            StopTimer();
            StartTimer();
            //if (e.keyCode == 13) { return false; }
        });

        //resets inactive timer on click of a radio element
        $('input[type=radio]').click(function (e) {
            StopTimer();
            StartTimer();
        });

        //resets inactive timer on click of a checkbox element
        $('input[type=checkbox]').click(function (e) {
            StopTimer();
            StartTimer();
        });


        processPersonReporting_Click();
        processRadioButtonQ_Click();

        window.onbeforeunload = function () {
            return;
        }
    });                      // END $(document).ready(function()


    function processPersonReporting_Click() {
        // Handle Person Reporting Detail text box
        var currIndex = GetListIndexSelected("<%=RadioButtonListPersonReporting.ClientID%>");
        var otherIndex = GetLastElementIndex("<%=RadioButtonListPersonReporting.ClientID%>");

        if (currIndex == otherIndex) {
            $('#<%= TextBoxPersonReportingDetail.ClientID %>').show();
        }
        else {
            $('#<%= TextBoxPersonReportingDetail.ClientID %>').hide();
            $('#<%= TextBoxPersonReportingDetail.ClientID %>').val('');
        }
    };

    function processQ7A_Click() {
        if (GetListIndexSelected("<%=RadioButtonListQ7A.ClientID%>") > -1) {
            if ((GetListIndexSelected("<%=RadioButtonListQ7B.ClientID%>") > -1) || (GetListIndexSelected("<%=RadioButtonListQ7BR.ClientID%>") > -1)) {
                //Clear previously entered response to Q7B-R and Q7B
                clearRadioButtonListSelection("<%=RadioButtonListQ7BR.ClientID%>");
                clearRadioButtonListSelection("<%=RadioButtonListQ7B.ClientID%>");

                var msg = "Your previously entered response to Question 7B has been cleared.";
                alert(msg);
            }
        }

        processRadioButtonQ_Click();
    }

    function processQ7B_Click() {
        if (GetListIndexSelected("<%=RadioButtonListQ7B.ClientID%>") > -1) {
            if (GetListIndexSelected("<%=RadioButtonListQ7A.ClientID%>") > -1) {
                //Clear previously entered response to Q7A
                clearRadioButtonListSelection("<%=RadioButtonListQ7A.ClientID%>");

                var msg = "Your previously entered response to Question 7A has been cleared.";
                alert(msg);
            }
        }

        processRadioButtonQ_Click();
    }

    function clearRadioButtonListSelection(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");

        var currIndex = GetListIndexSelected(listName);
        if (currIndex > -1) {
            radio[currIndex].checked = false;
        }
    }

    function GetListIndexSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = i;
                break;
            }
        }

        return ret;

    }

    function GetListValueSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var hiddenNoteID = $('<%=prevNoteID.ClientID%>');
        var ret = "";

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = radio[i].value;
                var o = ret.split(',');

                hiddenNoteID.value = o[0].toString();
                var _rbNoteType = document.getElementById("<%=rbNoteType.ClientID%>");
                var radio2 = _rbNoteType.getElementsByTagName("input");
                var spn = _rbNoteType.getElementsByTagName("span");
                //if (((o[1].toString() == "0"))) {
                //    alert("nobody");
                //}

                switch (o[2].toString()) {
                    case "0":
                        //radio2.items[1].Enabled = true;
                        //radio2.items[2].Enabled = true;
                        //radio2.items[3].Enabled = false;
                        break;
                    default:
                        //radio2[1].Enabled = "true";
                        //radio2[2].Enabled = "true";
                        //radio2[3].Enabled = "false";
                }

                break;
            }
        }

        return ret;

    }
    function processRadBtnPrevNotes_Click() {
        var InitialNote = GetListValueSelected("<%=prevNotesList.ClientID%>");
    }
    function processRadioButtonQ_Click() {
        //Calculate Raw Score and T Score
        var tScore;
        var rawScore;

        var q1 = GetListIndexSelected("<%=RadioButtonListQ1.ClientID%>");
        var q2 = GetListIndexSelected("<%=RadioButtonListQ2.ClientID%>");
        var q3 = GetListIndexSelected("<%=RadioButtonListQ3.ClientID%>");
        var q4 = GetListIndexSelected("<%=RadioButtonListQ4.ClientID%>");
        var q5 = GetListIndexSelected("<%=RadioButtonListQ5.ClientID%>");

        var q6 = GetListIndexSelected("<%=RadioButtonListQ6.ClientID%>");
        switch (q6) {
            case -1:
                break;
            case 0: case 1:
                q6 = 0;
                break;
            case 2: case 3:
                q6 = 1;
                break;
            case 4:
                q6 = 3;
                break;
            default:
                alert("Unrecognized score in Question 6");
                break;
        }

        var q7 = GetListIndexSelected("<%=RadioButtonListQ7A.ClientID%>");
        if (q7 < 0) {
            q7 = GetListIndexSelected("<%=RadioButtonListQ7B.ClientID%>");
        }
        switch (q7) {
            case -1:
                break;
            case 0:
                q7 = 0;
                break;
            case 1: case 2:
                q7 = 1;
                break;
            case 3: case 4:
                q7 = 3;
                break;
            default:
                alert("Unrecognized score in Question 7");
                break;
        }

        var q8 = GetListIndexSelected("<%=RadioButtonListQ8.ClientID%>");

        if ((q1 < 0) || (q2 < 0) || (q3 < 0) || (q4 < 0) || (q5 < 0) || (q6 < 0) || (q7 < 0) || (q8 < 0)) {
            rawScore = "N/A";
        }
        else {
            rawScore = q1 + q2 + q3 + q4 + q5 + q6 + q7 + q8;
        }

        switch (rawScore) {
            case 0:
                tScore = 7;
                break;
            case 1:
                tScore = 19;
                break;
            case 2:
                tScore = 25;
                break;
            case 3:
                tScore = 28;
                break;
            case 4:
                tScore = 31;
                break;
            case 5:
                tScore = 33;
                break;
            case 6:
                tScore = 34;
                break;
            case 7:
                tScore = 36;
                break;
            case 8:
                tScore = 37;
                break;
            case 9:
                tScore = 38;
                break;
            case 10:
                tScore = 39;
                break;
            case 11:
                tScore = 40;
                break;
            case 12:
                tScore = 41;
                break;
            case 13:
                tScore = 42;
                break;
            case 14:
                tScore = 43;
                break;
            case 15:
                tScore = 44;
                break;
            case 16:
                tScore = 45;
                break;
            case 17:
                tScore = 46;
                break;
            case 18:
                tScore = 47;
                break;
            case 19:
                tScore = 48;
                break;
            case 20:
                tScore = 49;
                break;
            case 21:
                tScore = 50;
                break;
            case 22:
                tScore = 52;
                break;
            case 23:
                tScore = 53;
                break;
            case 24:
                tScore = 55;
                break;
            case 25:
                tScore = 57;
                break;
            case 26:
                tScore = 59;
                break;
            case 27:
                tScore = 62;
                break;
            case 28:
                tScore = 65;
                break;
            case 29:
                tScore = 69;
                break;
            case 30:
                tScore = 74;
                break;
            default:
                tScore = "N/A";
                break;
        }

        var lblRawScore = document.getElementById("<%=LabelRawScore.ClientID%>");
        lblRawScore.innerText = rawScore;
        document.getElementById("<%=hiddenRawScore.ClientID%>").value = rawScore;

        var lblRawScore_2 = document.getElementById("<%=LabelRawScore_2.ClientID%>");
        lblRawScore_2.innerText = rawScore;
        document.getElementById("<%=hiddenRawScore_2.ClientID%>").value = rawScore;

        var lblTScore = document.getElementById("<%=LabelTScore.ClientID%>");
        lblTScore.innerText = tScore;
        document.getElementById("<%=hiddenTScore.ClientID%>").value = tScore;
        var lblTScore_2 = document.getElementById("<%=LabelTScore_2.ClientID%>");
        lblTScore_2.innerText = tScore;
        document.getElementById("<%=hiddenTScore_2.ClientID%>").value = tScore;
    };

    function checkQ7AQ7B(sender, args) {

        var retQ7A = GetListIndexSelected("<%=RadioButtonListQ7A.ClientID%>");
        var retQ7B = GetListIndexSelected("<%=RadioButtonListQ7B.ClientID%>");

        if ((retQ7A == -1) && (retQ7B == -1)) {
            args.IsValid = false;
            return;
        }
        else {
            args.IsValid = true;
            return;
        }
    }

    function validatePersonReportingDetail(sender, args) {

        var currIndex = GetListIndexSelected("<%=RadioButtonListPersonReporting.ClientID%>");
        var otherIndex = GetLastElementIndex("<%=RadioButtonListPersonReporting.ClientID%>");

        if (currIndex == otherIndex) {
            var txtPersonReportingDetail = document.getElementById("<%=TextBoxPersonReportingDetail.ClientID%>");
            if ($('#<%= TextBoxPersonReportingDetail.ClientID %>').val() == "") {
                args.IsValid = false;
                return;
            }
            else {
                args.IsValid = true;
                return;
            }

        }

    }

    function GetLastElementIndex(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        ret = radio.length - 1;

        return ret;
    }

    function validateQ7BR(sender, args) {
        var q7BRIndex = GetListIndexSelected("<%=RadioButtonListQ7BR.ClientID%>");
        var q7BIndex = GetListIndexSelected("<%=RadioButtonListQ7B.ClientID%>");

        if ((q7BIndex > -1) && (q7BRIndex < 0)) {
            args.IsValid = false;
            return;
        }
        else {
            args.IsValid = true;
            return;
        }

    }

    function btnSaveButtonChange_Click() {
        //Save draft if question 8,15,16V,28 is changed occurs
        //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
        //alert("Auto-Saving");
    }

</script> 
</telerik:RadCodeBlock>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
<div id="skiplink">
    <a href="#content">skip to page content</a>
</div>
<asp:Menu 
    ID="Menu2" 
    runat="server" 
    SkipLinkText="Skip Left Navigation Links"
    DynamicHorizontalOffset="2"  Width="166px" 
    StaticMenuItemStyle-CssClass = "leftMenuItem"  
    DynamicMenuItemStyle-CssClass = "leftMenuItem"  
    StaticDisplayLevels="3" Height="134px" 
    onmenuitemclick="Menu2_MenuItemClick" >
    <StaticHoverStyle CssClass= "leftMenuItemHover" />
    <DynamicHoverStyle CssClass= "leftMenuItemHover" />
</asp:Menu>
<div class="breadcrumbInstrument">
        <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > THE MAYO-PORTLAND ADAPTABILITY INVENTORY (MPAI-4)"></asp:Label> 
</div>
</telerik:RadCodeBlock>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock4">
<asp:UpdatePanel ID="MainUpdatePanel" runat="server">
    <ContentTemplate>
            <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" 
                TabIn="1" 
                HeaderText="The page has the following data errors:" 
                DisplayMode="BulletList" 
                ShowSummary="false" 
                ShowMessageBox="true" 
                ValidationGroup="OnSave" 
            />
        <asp:Panel ID="ProcessingPanel" runat="server" Visible="false">   
        <br />
            <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
            <ProgressTemplate>
                <!-- Modal Popup for Loading -->
              <div style="padding-left: 3px;" >
                    <div style="background-color: #FF0000; width: 300px; color: #FFFFFF; padding: 5px;">
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                    </div>
                </div>
              
                <!-- End Modal Popup for Loading -->
            </ProgressTemplate>
        </asp:UpdateProgress>
        <br />
</asp:Panel>
            <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">

            <table cellpadding = "5" cellspacing = "5">
                <tr>
                    <td>
                         &nbsp;&nbsp;<asp:Label ID = "LabelForName" runat = "server" Text = "Patient:" AssociatedControlID = "LabelPatient" SkinID="DataLabel"  TabIn="10"></asp:Label>&nbsp;<asp:Label ID="LabelPatient" runat = "server" SkinID="DataLabel" TabIn="11"></asp:Label></td>
                    <td>
                        <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelSSN" Text = "SSN:" TabIn="12"></asp:Label>
                        &nbsp;<asp:Label ID="LabelSSN" runat = "server" SkinID="DataLabel" TabIn="13"></asp:Label></td>
                    <td>
                        <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID = "LabelFacility" Text = "Facility:" Visible="false"></asp:Label>
                        &nbsp;<asp:Label ID="LabelFacility" runat = "server" SkinID="DataLabel"></asp:Label></td>
                </tr>
            </table>
            </asp:Panel>
                 
            <asp:HiddenField ID="HiddenSurveyType" runat="server"  Value="MPAI" />
            
            <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server">
                <table cellpadding = "5" cellspacing = "5" width = "100%" border="1">
                    <tr align="center">
                        <td colspan="2">
                            <asp:Label ID="LabelInstrumentTitle" runat="server" style="font-weight:bold"  SkinID="DataLabel" TabIn="14" />
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="RawScoreLabel_2" AssociatedControlID="LabelRawScore_2" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel">
                            Raw Score:&nbsp;
                            </asp:Label>
                            <asp:Label ID="LabelRawScore_2" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel">
                            </asp:Label>
                            <asp:HiddenField ID="hiddenRawScore_2" runat="server"  Value="N/A"  />
                            
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        </td>
                        <td>
                            <asp:Label ID="TScoreLabel_2" AssociatedControlID="LabelTScore_2" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel">
                            T Score: &nbsp;
                            </asp:Label>
                            <asp:Label ID="LabelTScore_2" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel">
                            </asp:Label>
                            <asp:HiddenField ID="hiddenTScore_2" runat="server"  Value=""  />
                            <br /><br />
                        </td>                        
                    </tr>
                    <tr>
                        <td width="100%" colspan="2">
                            &nbsp;&nbsp;&nbsp;&nbsp;
                        </td>
                    </tr>
                    <tr>
                        
                        <td width="100%" colspan="2">
                             <asp:Label ID="LabelNoteDate" AssociatedControlID="prevNotesList" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="15">
                            Previous Initial M2PI Instrument Dates:
                            </asp:Label>
                            <table><tr><td>
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                                
                                        <asp:RadioButtonList ID="prevNotesList" runat="server" RepeatDirection="Vertical"
                                            AutoPostBack="true"
                                            OnSelectedIndexChanged="Index_Changed"
                                            DataTextField="prevM2PINoteInfo"
                                            DataValueField="Surveys_ID"
                                            AppendDataBoundItems="true"  SkinID="DataLabel" TabIn="16">
                                            <asp:ListItem Text = "New Instance of Care  Do not add to prior notes" Value = "self"></asp:ListItem>  
                                        </asp:RadioButtonList>
                                
                                        <asp:HiddenField ID="prevNoteID" runat="server"  Value="" />
                                        </td>
                                        <td>
                           
                       <!-- </td>
                    </tr>
                    <tr><td> -->
                                 </td></tr></table>      
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            &nbsp;&nbsp;&nbsp;&nbsp;<asp:Label ID="NoteTypeLabel" runat="server" AssociatedControlID = "LabelNoteType"  SkinID="DataLabel" TabIn="17">Note Type:</asp:Label>
                            <asp:Label ID="LabelNoteTypeID" runat="server" visible="false"  SkinID="DataLabel" TabIn="18"></asp:Label>
                            &nbsp;<asp:Label ID="LabelNoteType" runat="server" visible="false" SkinID="DataLabel"  TabIn="19"></asp:Label>
                                     <asp:RadioButtonList ID="rbNoteType" runat="server" RepeatDirection="Horizontal"
                                        DatasourceID="ObjectDataSource1"
                                        DataTextField="CHOICE_TEXT"
                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                        onclick="processRadioButtonQ_Click()"
                                        SkinID="DataLabel" TabIn="20">
                                    </asp:RadioButtonList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1"
                                        ControlToValidate="rbNoteType"
                                        Display="Static"
                                        runat="server"
                                        EnableClientScript="true"
                                        ErrorMessage = "Note type is required."
                                        SetFocusOnError="true"
                                        ValidationGroup = "OnSave"  SkinID="DataLabel" TabIn="21">
                                    </asp:RequiredFieldValidator>
                                    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
                                        SelectMethod="GetQuestionChoices"
                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="Question_Number" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="Question_Number" runat="server"  Value="-1" />
                                    <asp:HiddenField ID="SurveyDate" runat="server"   />
                    </tr>

                    <tr>
                        <td colspan="2">
                            <asp:Label ID="PersonReportingLabel" runat="server" AssociatedControlID = "RadioButtonListPersonReporting"  SkinID="DataLabel" TabIn="22">Person Reporting:</asp:Label>
                            <br />
                            <asp:RadioButtonList ID="RadioButtonListPersonReporting" runat="server" RepeatDirection="Horizontal"
                            DatasourceID="ObjectDataSourcePersonReporting"
                            DataTextField="CHOICE_TEXT"
                            DataValueField="STD_QUESTION_CHOICE_ID"
                            onclick="processPersonReporting_Click()"
                             SkinID="DataLabel" TabIn="14">
                            </asp:RadioButtonList>
                            <asp:TextBox ID="TextBoxPersonReportingDetail" runat="server" style="display:none"
                                Width="50%"   
                                CssClass="PersonReportingDetail"  SkinID="DataLabel" TabIn="23">
                            </asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorPersonReporting"
                                ControlToValidate="RadioButtonListPersonReporting"
                                Display="Dynamic"
                                runat="server"
                                EnableClientScript="true"
                                ErrorMessage = "Person Reporting entry is required."
                                SetFocusOnError="true"
                                ValidationGroup = "OnSave"
                             SkinID="DataLabel" TabIn="24" />
                             <asp:CustomValidator ID="CustomValidatorPersonReportingDetail"
                                ControlToValidate="TextBoxPersonReportingDetail"
                                ValidateEmptyText="true"
                                runat="server"
                                Display="Dynamic"
                                ErrorMessage = "Please specify Significant Other for the Person Reporting entry."
                                ClientValidationFunction="validatePersonReportingDetail"
                                ValidationGroup = "OnSave"
                                SetFocusOnError="true" 
                             SkinID="DataLabel" TabIn="25" />
                            <asp:ObjectDataSource ID="ObjectDataSourcePersonReporting" runat="server" 
                                SelectMethod="GetQuestionChoices"
                                TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                <SelectParameters>
                                    <asp:ControlParameter ControlID="HiddenQ0" Direction="Input" Name="questionNumber" Type="String" />
                                </SelectParameters>
                            </asp:ObjectDataSource>
                            <asp:HiddenField ID="HiddenQ0" runat="server"  Value="0" />
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            
            <asp:Panel ID="PanelQuestions" Width="100%" runat="server">
                <table cellpadding = "5" cellspacing = "5" width = "100%">
                    <tr>
                        <td colspan="2">
                            <asp:Label ID="LabelInstrumentDesc" runat="server" SkinID="DataLabel"  TabIn="26">
                            Below each item, select the number that best describes the level at which the person being evaluated 
                            experiences problems. Mark the greatest level of problem that is appropriate. Problems that interfere 
                            rarely with daily or valued activities, that is, less than 5% of the time, should be considered not to 
                            interfere. Write comments about specific items at the end of the rating scale.
                            </asp:Label>
                            <br />
                        </td>
                    </tr>
                    <tr id="TrQ1">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q1Label" AssociatedControlID="RadioButtonListQ1" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="27">
                                        1. Initiation:  Problems getting started on activities without prompting
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ1" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ1"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="28">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1"
                                            ControlToValidate="RadioButtonListQ1"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 1 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel"  TabIn="29">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ1" runat="server"  Value="1" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C1Label" AssociatedControlID="TextBoxC1" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="30">
                                        Comment Item #1: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC1" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer"  SkinID="DataLabel" TabIn="31">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                           </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr id="TrQ2">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q2Label" AssociatedControlID="RadioButtonListQ2" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="32">
                                        2. Social contact with friends, work associates, and other people who are not family, significant others, or professionals
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ2" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ2"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="33">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2"
                                            ControlToValidate="RadioButtonListQ2"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 2 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIn="34">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ2" runat="server" Value="2" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C2Label" AssociatedControlID="TextBoxC2" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="35">
                                        Comment Item #2: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC2" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="36">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ3">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q3Label" AssociatedControlID="RadioButtonListQ3" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="37">
                                        3. Leisure and recreational activities
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ3" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ3"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="38">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3"
                                            ControlToValidate="RadioButtonListQ3"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 3 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" SkinID="DataLabel"  TabIn="39">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ3" runat="server" Value="3" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C3Label" AssociatedControlID="TextBoxC3" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="40">
                                        Comment Item #3: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC3" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="41">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ4">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q4Label" AssociatedControlID="RadioButtonListQ4" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="42">
                                        4. Self-care: Eating, dressing, bathing, hygiene
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ4" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ4"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="43">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4"
                                            ControlToValidate="RadioButtonListQ4"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 4 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave" SkinID="DataLabel"  TabIn="44">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ4" runat="server" Value="4" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C4Label" AssociatedControlID="TextBoxC4" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="45">
                                        Comment Item #4: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC4" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="46">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                           </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ5">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q5Label" AssociatedControlID="RadioButtonListQ5" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="47">
                                        5. Residence: Responsibilities of independent living and homemaking(such as meal preparation, home repairs 
                                        and maintenance, personal health maintenance beyond basic hygiene including medical management) 
                                        but not including managing money (see # 8)
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ5" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ5"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="48">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5"
                                            ControlToValidate="RadioButtonListQ5"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 5 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIn="49">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ5" runat="server" Value="5" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C5Label" AssociatedControlID="TextBoxC5" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="50">
                                        Comment Item #5: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC5" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="51">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ6">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q6Label" AssociatedControlID="RadioButtonListQ6" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="52">
                                        6. Transportation
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ6" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ6"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()"
                                         SkinID="DataLabel" TabIn="53">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6"
                                            ControlToValidate="RadioButtonListQ6"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 6 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIn="54">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ6" runat="server" Value="6" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C6Label" AssociatedControlID="TextBoxC6" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="55">
                                        Comment Item #6: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC6" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer"  SkinID="DataLabel" TabIn="56">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ7A">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q7ALabel" AssociatedControlID="RadioButtonListQ7A" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="57">
                                        7A. Paid Employment: Rate either item 7A or 7B to reflect the primary desired social role. Do not rate both. 
                                        Rate 7A if the primary social role is paid employment. If another social role is primary, rate only 7B. 
                                        For both 7A and 7B, support means special help from another person with responsibilities 
                                        (such as, a job coach or shadow, tutor, helper) or reduced responsibilities. Modifications to the 
                                        physical environment that facilitate employment are not considered as support.
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <asp:RadioButtonList ID="RadioButtonListQ7A" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ7A"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processQ7A_Click()"
                                         SkinID="DataLabel" TabIn="58">
                                        </asp:RadioButtonList>
                                        <br />
                                        <asp:CustomValidator ID="CustomValidatorQ7A"
                                            ControlToValidate="RadioButtonListQ7A"
                                            ValidateEmptyText="true"
                                            runat="server"
                                            Display="Static"
                                            ErrorMessage = "Response to either Question 7A or 7B is required."
                                            ClientValidationFunction="checkQ7AQ7B"
                                            ValidationGroup = "OnSave"
                                            EnableClientScript="true"
                                            SetFocusOnError="true" 
                                         SkinID="DataLabel" TabIn="59" />
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ7A" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ7A" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ7A" runat="server" Value="7A" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C7ALabel" AssociatedControlID="TextBoxC7A" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="60">
                                        Comment Item #7A: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC7A" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="61">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ7B">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q7BLabel" AssociatedControlID="RadioButtonListQ7B" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="62">
                                        7B. Other employment: Involved in constructive, role-appropriate activity other than paid employment.
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <fieldset class="secondLevelAnswer">
                                        <table width="100%">
                                            <tr class="subquestionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q7BRLabel" AssociatedControlID="RadioButtonListQ7B" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="63">
                                                    Primary Desired Role:
                                                    </asp:Label>
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="RadioButtonListQ7BR" runat="server" RepeatDirection="Vertical" 
                                                        DatasourceID="ObjectDataSourceQ7BR"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                     SkinID="DataLabel" TabIn="64">
                                                    </asp:RadioButtonList>
                                                     <asp:CustomValidator ID="CustomValidatorQ7BR"
                                                        ControlToValidate="RadioButtonListQ7BR"
                                                        runat="server"
                                                        Display="Static"
                                                        ErrorMessage = "Primary Desired Role entry in Question 7B is required."
                                                        ClientValidationFunction="validateQ7BR"
                                                        ValidationGroup = "OnSave"
                                                        EnableClientScript="true"
                                                        ValidateEmptyText="true"
                                                        SetFocusOnError="true" 
                                                     SkinID="DataLabel" TabIn="65" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ7BR" runat="server" 
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ7BR" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ7BR" runat="server"  Value="7B-R" />
                                                </td>
                                            </tr>
                                        </table>
                                        </fieldset>
                                        
                                        <br />
                                        <asp:RadioButtonList ID="RadioButtonListQ7B" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ7B"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processQ7B_Click()"
                                         SkinID="DataLabel" TabIn="66">
                                        </asp:RadioButtonList>
                                        <br />
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ7B" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ7B" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ7B" runat="server" Value="7B" />
                            
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C7BLabel" AssociatedControlID="TextBoxC7B" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="67">
                                        Comment Item #7B: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC7B" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="68">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>
                    <tr id="TrQ8">
                        <td>
                            <fieldset>
                            <table width="100%">
                                <tr class="questionBackgroundColor">
                                    <td colspan="2">
                                        <asp:Label ID="Q8Label" AssociatedControlID="RadioButtonListQ8" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="69">
                                        8. Managing money and finances: Shopping, keeping a check book or other bank account, managing personal income and investments
                                        </asp:Label>
                                        <br />
                                        <br />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2"><!--onchange="btnSaveButtonChange_Click()"-->
                                        <asp:RadioButtonList ID="RadioButtonListQ8" runat="server" RepeatDirection="Vertical"
                                            DatasourceID="ObjectDataSourceQ8"
                                            DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID"
                                            onclick="processRadioButtonQ_Click()" 
                                             SkinID="DataLabel" TabIn="70">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8"
                                            ControlToValidate="RadioButtonListQ8"
                                            Display="Static"
                                            runat="server"
                                            EnableClientScript="true"
                                            ErrorMessage = "Response to Question 8 is required."
                                            SetFocusOnError="true"
                                            ValidationGroup = "OnSave"  SkinID="DataLabel" TabIn="71">
                                        </asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" 
                                            SelectMethod="GetQuestionChoices"
                                            TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ8" runat="server" Value="8" />
                                    </td>
                                </tr>
                                <tr>
                                    <td width="12%">
                                        <asp:Label ID="C8Label" AssociatedControlID="TextBoxC8" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="72">
                                        Comment Item #8: 
                                        </asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TextBoxC8" runat="server" Width="98%"   
                                            TextMode="MultiLine" Rows="2" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="73">
                                        </asp:TextBox>
                                    </td>
                                </tr>
                            </table>
                            </fieldset> 
                        </td>
                    </tr>

        

                </table>
            </asp:Panel>
  
    <br />

    <asp:Panel ID="PanelScore" Width="100%" runat="server">
        <table cellpadding = "5" cellspacing = "5">
            <tr>
                <td>
                    <asp:Label ID="RawScoreLabel" AssociatedControlID="LabelRawScore" runat="server" CssClass="firstLevelQuestion" SkinID="DataLabel"  TabIn="74">
                    Raw Score: 
                    </asp:Label>
                </td>
                 <td>
                    <asp:Label ID="LabelRawScore" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="75">
                    </asp:Label>
                     <asp:HiddenField ID="hiddenRawScore" runat="server"  Value="N/A"  />
                    
                </td>
                <td width="50%"></td>
                <td>
                    <asp:Label ID="TScoreLabel" AssociatedControlID="LabelTScore" runat="server" CssClass="firstLevelQuestion"  SkinID="DataLabel" TabIn="76">
                    T Score: 
                    </asp:Label>
                </td>
                 <td>
                    <asp:Label ID="LabelTScore" runat="server" CssClass="firstLevelAnswer" SkinID="DataLabel"  TabIn="77">
                    </asp:Label>
                    <asp:HiddenField ID="hiddenTScore" runat="server" Value=""  />
                </td>
           </tr>
        </table>
    </asp:Panel>
    <asp:HiddenField ID="ParentNoteID" runat="server" Value="New"  />
   
    <br />

        

                &nbsp;&nbsp;          
                <asp:Button ID = "btnSaveSurveyDraft" runat = "server"                    
                    UseSubmitBehavior = "false" 
                    Text = "Save Draft" 
                    Width = "130px" 
                    OnClick = "btnSaveSurveyDraft_Click" 
                    ValidationGroup = "OnSaveDraft"
                 SkinID="DataLabel" TabIn="78" /> 
                       
                <asp:Button ID = "btnSubmitSurvey" runat =  "server"                     
                    UseSubmitBehavior = "false" 
                    Text = "Save and Prepare Note" 
                    Width = "180px" 
                    OnClick = "btnSubmit_Click" 
                    ValidationGroup = "OnSave" 
                 SkinID="DataLabel" TabIn="79" />
                
                <asp:Button ID = "btnCancelSurvey" runat = "server" 
                     SkinID="DataLabel" TabIn="80" 
                    UseSubmitBehavior = "false" 
                    Text = "Cancel" 
                    Width = "130px" 
                    OnClick = "btnCancel_Click" 
                />
                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />

                <br />
                <br />     
                <asp:Label ID="LabelSaveInstructions" runat="server" SkinID="DataLabel" TabIn="81">
                        If you are unable to finish at this time, or if you just want to save while entering, click Save Draft.<br /><br />

                        If you are finished with entry, and ready to save and format the note (you will get another chance to review prior to submit),<br /> 
                        click Save and Prepare Note.<br /><br />     
                          
                        If you want to return to CPRS press the Cancel Button. Do not use Internet browser back arrow.               
                </asp:Label>
                <br />
            
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>

